/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package salesApplication;

import java.util.function.Predicate;
import products.Item;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Search {
    //This class allows us to search our price lists for items where fields such as name
    //and decsription match a specified search criteria.

    //Given a price list, search for all items where something in the description or name matches 
    //the search string
    public static PriceList searchList(PriceList priceList,String pattern){
        //Simple search for string in name or description
        
        //Create the search functionality and save it in a lambda expression
        Predicate<Item> searchFunctionality = (item)->{
            boolean found;
            //
            //Search logic goes here!
            //
            //The pattern is in the name or the description.
            found = (item.getName().contains(pattern))||(item.getDescription().contains(pattern));
            
            //Retrun the result of our search.
            return found; 
        };
        
        //Use the lambda expression to filter the list.
        return priceList.filterList(searchFunctionality);
    }
    
}
